#ifndef CE2_TST_AES_H
#define CE2_TST_AES_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif


/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wen Mar 14 10:17:10 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_AES.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines *******************************/
#define TST_NAME_STRING_LEN 150
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536
#define TST_CBC_MAC_SIZE 16
#define TST_KEYWRAP_IV_SIZE_IN_BYTES 8
#define TST_FUNC_STRING_LEN 100
#define TST_ENCRYPT 0
#define TST_MAX_SINGLE_AES_BLOCK_SIZE_IN_BYTS 16

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/

typedef struct TST_AES_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_AES_Key_t 				TST_Key;
  CE2_AES_KeySize_t			TST_KeySize;
  CE2_AES_IvCounter_t		TST_IvCounter;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint8_t 					TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint8_t 					TST_Expected_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint16_t					TST_dataSize;	
  CE2_AES_OperationMode_t	TST_OperationMode;
} TST_AES_TestDataStruct;

typedef struct TST_AES_MAC_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_AES_Key_t 				TST_Key;
  CE2_AES_KeySize_t			TST_KeySize;
  CE2_AES_IvCounter_t		TST_IvCounter;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint8_t 					TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint16_t					TST_dataSize;
  DxUint8_t 					TST_Expected_CBC_MAC[TST_CBC_MAC_SIZE];
  CE2_AES_OperationMode_t	TST_OperationMode;
} TST_AES_MAC_TestDataStruct;

typedef struct TST_AES_KeyWrap_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  CE2_AES_Key_t 				TST_Key;
  CE2_AES_KeySize_t			TST_KeySize;
  DxUint8_t 					TST_InputData[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint16_t 					TST_InputDataSize;
  DxUint8_t 					TST_WrapdData[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint16_t 					TST_WrapdDataSize;
  DxUint8_t 					TST_ExpectedWrapedData[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint8_t 					TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
} TST_AES_KeyWrap_TestDataStruct;

typedef struct TST_AES_XCBC_MAC_OR_CMAC_TestDataStruct {
  char              TST_Name[TST_NAME_STRING_LEN];
  CE2_AES_Key_t     TST_Key;
  CE2_AES_KeySize_t	TST_KeySize;
  DxUint8_t 		    TST_InputData[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint32_t 		    TST_InputDataSize;
  DxUint8_t 		    TST_OutputData[CE2_AES_BLOCK_SIZE_IN_BYTES];
  DxUint8_t 				TST_ExpectedOutputData[CE2_AES_BLOCK_SIZE_IN_BYTES];
} TST_AES_XCBC_MAC_OR_CMAC_TestDataStruct;

/************************ Public Variables **********************/

extern TST_AES_TestDataStruct 	 		TST_AES_Acceptance_TestData[];
extern TST_AES_MAC_TestDataStruct       TST_AES_MAC_Acceptance_TestData[];
extern TST_AES_KeyWrap_TestDataStruct   TST_ARS_KeyWrap_Acceptance_TestData[];
extern const int				        TST_NumberOf_AES_AcceptanceTests;
extern const int				        TST_NumberOfMACAcceptanceTests;
extern const int				        TST_NumberOfKeyWrapAcceptanceTests;

extern TST_AES_XCBC_MAC_OR_CMAC_TestDataStruct TST_AES_XCBC_MAC_TestData[];
extern TST_AES_XCBC_MAC_OR_CMAC_TestDataStruct TST_AES_CMAC_TestData[];
extern const int				        TST_AES_XCBC_MAC_TestNumber;
extern const int				        TST_AES_CMAC_TestNumber;

/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_AES_Acceptance_Integrated 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for AES integrated API							
* 	This function Encrypts and Decrypts known vectors using AES
*  AES modes                   - CBC/EBC/CTR  
* 	Vector sizes used (in bytes) - 16/32/512/1536								
* 	Key Size used (in bits)	    - 128/192/256								
* 	This also outputs the results to an output buffer or the same input buffer
* Algorithm:		
* 1. Call the CE2_AES function to use the AES encryprion/decryption process
* 2. Compare the outputted result to the expected one													
*
******************************************************************************/	
CE2Error_t CE2_ATP_TST_AES_Acceptance_Integrated (FILE* out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_AES_Acceptance_MAC_integrated 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for AES non integrated API's							
* 	This function Encryprts and Decrypts known vectors using AES
*  AES modes                   - MAC  
* 	Vector sizes used (in bytes) - 16/32/512/1536								
* 	Key Size used (in bits)	    - 128/192/256								
* 	This also outputs the results to an output buffer or the same input buffer
* Algorithm:		
* 1. Call the CE2_AES_Init function to start the encryprion/decryption process
* 2. Compare the outputted result to the expected one													
*
******************************************************************************/
CE2Error_t CE2_ATP_TST_AES_Acceptance_MAC_integrated (FILE* out);

/*****************************************************************************
* Function Name:                                                           
*  CE2_ATP_TST_AES_Acceptance_KeyWrapUnwarp      
*  
* Inputs:
*  None
*
* Outputs: 
*  CE2Error_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES wrap unwrap  API's
*  This function wraps and unwraps known vectors using AES
*  Vector sizes used (in bytes) - 16/32/512                                 
*  Key Size used (in bits)     - 128/192/256                               
* Algorithm:       
* 1. Call the CE2_Wrap and Unwrap function to use the AES wrap/unwrap process
* 2. Compare the outputted result to the expected one                                                      
*
******************************************************************************/    
CE2Error_t CE2_ATP_TST_AES_Acceptance_KeyWrapUnwarp (FILE* out) ;

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_AES_XCBC_MAC 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a  test for DX_AES (in XCBC_MAC mode)							
* 	This function Encrypts and Decrypts known vectors using AES
*  AES modes                   - XCBC_MAC  
* 	Vector sizes used (in bytes) - 0/3/16/20/32								
* 	Key Size used (in bits)	    - 128								
* 	This also outputs the results to an output buffer or the same input buffer
* Algorithm:		
* 1. Call the DX_AES function to use the AES encryprion process
* 2. Compare the outputted result to the expected one													
*
******************************************************************************/	
CE2Error_t CE2_TST_AES_XCBC_MAC(FILE* out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_AES_CMAC 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a  test for DX_AES (in CMAC mode)							
* 	This function Encrypts and Decrypts known vectors using AES
*  AES modes                   - XCBC_MAC  
* 	Vector sizes used (in bytes) - 0/16/40/64								
* 	Key Size used (in bits)	    - 128								
* 	This also outputs the results to an output buffer or the same input buffer
* Algorithm:		
* 1. Call the DX_AES function to use the AES encryprion process
* 2. Compare the outputted result to the expected one													
*
******************************************************************************/	
CE2Error_t CE2_TST_AES_CMAC(FILE* out);

CE2Error_t CE2_TST_XTS_AES_EncryptDecrypt(FILE* out);
CE2Error_t CE2_TST_XTS_AES_EncryptDecrypt_TweakInternal(FILE* out);
CE2Error_t CE2_TST_XTS_AES_CRYS_COMPARE(FILE* out);

CE2Error_t CE2_TST_AES_CCM_01(FILE* out);

CE2Error_t CE2_TST_AES_GCM_01(FILE* out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_AES_H */
